VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "QuickStuff"
   ClientHeight    =   6675
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9465
   LinkTopic       =   "Form1"
   ScaleHeight     =   6675
   ScaleWidth      =   9465
   StartUpPosition =   3  'Windows Default
   Begin VB.OptionButton optOptions 
      Caption         =   "Quick FITS"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   2
      Left            =   3240
      TabIndex        =   44
      Top             =   120
      Width           =   1455
   End
   Begin VB.Frame vBin 
      Caption         =   "Quick FITS Key"
      Height          =   5775
      Left            =   0
      TabIndex        =   29
      Top             =   600
      Visible         =   0   'False
      Width           =   9135
      Begin VB.ComboBox cmbType 
         Height          =   315
         ItemData        =   "frmMain.frx":0000
         Left            =   6120
         List            =   "frmMain.frx":000D
         Style           =   2  'Dropdown List
         TabIndex        =   45
         Top             =   360
         Width           =   1215
      End
      Begin VB.TextBox txtKeyValue 
         Height          =   285
         Left            =   3840
         TabIndex        =   43
         Top             =   360
         Width           =   2175
      End
      Begin VB.TextBox txtKey 
         Height          =   285
         Left            =   1560
         TabIndex        =   42
         Top             =   360
         Width           =   1575
      End
      Begin VB.ListBox lstImagesBin 
         Height          =   2595
         Left            =   360
         TabIndex        =   34
         Top             =   1080
         Width           =   2775
      End
      Begin VB.CommandButton cmdBinMove 
         Caption         =   "All >>"
         Height          =   375
         Index           =   0
         Left            =   3360
         TabIndex        =   33
         Top             =   1080
         Width           =   1095
      End
      Begin VB.CommandButton cmdBinMove 
         Caption         =   "<< All"
         Height          =   375
         Index           =   3
         Left            =   3360
         TabIndex        =   32
         Top             =   1680
         Width           =   1095
      End
      Begin VB.ListBox lstSelectedBin 
         Height          =   2595
         Left            =   4800
         TabIndex        =   31
         Top             =   1080
         Width           =   2775
      End
      Begin VB.CommandButton cmdSet 
         Caption         =   "Update Fits Header"
         Height          =   375
         Left            =   7440
         TabIndex        =   30
         Top             =   240
         Width           =   1575
      End
      Begin VB.Label Label6 
         Caption         =   "Key Name"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   4
         Left            =   360
         TabIndex        =   41
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "Loaded Images"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   3
         Left            =   360
         TabIndex        =   40
         Top             =   720
         Width           =   2655
      End
      Begin VB.Label Label6 
         Caption         =   "Loaded Images"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   1
         Left            =   4800
         TabIndex        =   39
         Top             =   720
         Width           =   1455
      End
      Begin VB.Label Label6 
         Caption         =   "Value"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   2
         Left            =   3240
         TabIndex        =   38
         Top             =   360
         Width           =   615
      End
      Begin VB.Label Label3 
         Caption         =   $"frmMain.frx":0029
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1935
         Index           =   2
         Left            =   240
         TabIndex        =   37
         Top             =   3720
         Width           =   8535
      End
      Begin VB.Label Label7 
         Caption         =   "Double Click file to move files back and forth."
         Height          =   1335
         Left            =   3360
         TabIndex        =   36
         Top             =   2280
         Width           =   1095
      End
      Begin VB.Label txtMessage4 
         Caption         =   "Updated"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   7200
         TabIndex        =   35
         Top             =   720
         Visible         =   0   'False
         Width           =   1455
      End
   End
   Begin VB.Frame vQuickStart 
      Caption         =   "Quick Start"
      Height          =   5775
      Left            =   0
      TabIndex        =   12
      Top             =   600
      Visible         =   0   'False
      Width           =   9135
      Begin VB.CommandButton cmdStart 
         Caption         =   "&Start Now"
         Default         =   -1  'True
         Height          =   375
         Left            =   360
         TabIndex        =   16
         Top             =   1800
         Width           =   975
      End
      Begin VB.CommandButton cmdQuit 
         Caption         =   "&End"
         Height          =   375
         Left            =   2040
         TabIndex        =   15
         Top             =   1800
         Width           =   735
      End
      Begin VB.Timer Timer1 
         Enabled         =   0   'False
         Interval        =   1000
         Left            =   1560
         Top             =   1800
      End
      Begin VB.ListBox lstLog 
         Height          =   1425
         Left            =   360
         TabIndex        =   14
         Top             =   2520
         Width           =   2535
      End
      Begin VB.CheckBox chkNoSet 
         Caption         =   "Do not set new temperature"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   360
         TabIndex        =   13
         Top             =   1080
         Width           =   2895
      End
      Begin VB.Label Label3 
         Caption         =   $"frmMain.frx":020B
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   5415
         Index           =   1
         Left            =   3600
         TabIndex        =   27
         Top             =   240
         Width           =   4575
      End
      Begin VB.Label txtMessage2 
         Caption         =   "None"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1200
         TabIndex        =   26
         Top             =   4800
         Width           =   4215
      End
      Begin VB.Label Label5 
         Caption         =   "Messages"
         Height          =   255
         Left            =   360
         TabIndex        =   25
         Top             =   4800
         Width           =   855
      End
      Begin VB.Label lblTemp 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   255
         Left            =   2520
         TabIndex        =   24
         Top             =   600
         Width           =   735
      End
      Begin VB.Label Label2 
         Caption         =   "CurrentTemperature"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   3
         Left            =   360
         TabIndex        =   23
         Top             =   600
         Width           =   1695
      End
      Begin VB.Label Label2 
         Caption         =   "Time Left"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   1
         Left            =   360
         TabIndex        =   22
         Top             =   4320
         Width           =   855
      End
      Begin VB.Label lblTime 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   255
         Left            =   1320
         TabIndex        =   21
         Top             =   4320
         Width           =   615
      End
      Begin VB.Label Label2 
         Caption         =   "Setpoint Temperature"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   2
         Left            =   360
         TabIndex        =   20
         Top             =   240
         Width           =   1935
      End
      Begin VB.Label lblSetTemp 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   255
         Left            =   2520
         TabIndex        =   19
         Top             =   240
         Width           =   735
      End
      Begin VB.Label Label2 
         Caption         =   "Log"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   4
         Left            =   360
         TabIndex        =   18
         Top             =   2280
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Set temperature yourself after camera stablizes"
         Height          =   375
         Index           =   1
         Left            =   600
         TabIndex        =   17
         Top             =   1320
         Width           =   2415
      End
   End
   Begin VB.OptionButton optOptions 
      Caption         =   "Quick Start"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   1
      Left            =   1800
      TabIndex        =   11
      Top             =   120
      Width           =   1455
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   8760
      TabIndex        =   10
      Top             =   0
      Width           =   615
   End
   Begin VB.Frame vQuickPath 
      Caption         =   "Quick Path"
      Height          =   5775
      Left            =   0
      TabIndex        =   1
      Top             =   600
      Width           =   9135
      Begin VB.TextBox txtPath 
         Height          =   285
         Left            =   1320
         TabIndex        =   4
         Text            =   "C:\MaximDL\"
         Top             =   960
         Width           =   3255
      End
      Begin VB.TextBox txtObject 
         Height          =   285
         Left            =   1320
         TabIndex        =   3
         Top             =   360
         Width           =   3015
      End
      Begin VB.CommandButton cmdCreate 
         Caption         =   "Create Path"
         Height          =   375
         Left            =   4560
         TabIndex        =   2
         Top             =   240
         Width           =   1095
      End
      Begin VB.Label txtMessage1 
         Caption         =   "None"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1080
         TabIndex        =   9
         Top             =   1680
         Width           =   4215
      End
      Begin VB.Label Label4 
         Caption         =   "Messages"
         Height          =   255
         Left            =   120
         TabIndex        =   8
         Top             =   1680
         Width           =   855
      End
      Begin VB.Label Label3 
         Caption         =   $"frmMain.frx":04C8
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1695
         Index           =   0
         Left            =   120
         TabIndex        =   7
         Top             =   2400
         Width           =   8295
      End
      Begin VB.Label Label2 
         Caption         =   "Home path"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   6
         Top             =   960
         Width           =   1095
      End
      Begin VB.Label Label1 
         Caption         =   "Image Name"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   5
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.OptionButton optOptions 
      Caption         =   "Quick Path"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Value           =   -1  'True
      Width           =   1455
   End
   Begin VB.Label Label6 
      Caption         =   "Freeware Plug-in for Maxim DL 4.0 or higher.  By Dean Salman, web site: http://www.galaxies.com"
      Height          =   495
      Index           =   0
      Left            =   4800
      TabIndex        =   28
      Top             =   0
      Width           =   3855
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim Camera As New CCDCamera ' MaxIm camera object
Dim MyApp As New Application
Dim iTimer As Integer
Dim bSetNewTemp As Boolean
Dim iLastTemp As Double



Private Sub cmdBinMove_Click(Index As Integer)
    
    Dim i As Integer
    
    
    Select Case Index
        Case 0
            For i = 0 To lstImagesBin.ListCount - 1
                lstSelectedBin.AddItem lstImagesBin.List(i)
            Next
            lstImagesBin.Clear
        
        Case 3
            For i = 0 To lstSelectedBin.ListCount - 1
                lstImagesBin.AddItem lstSelectedBin.List(i)
            Next
            lstSelectedBin.Clear
        
    End Select
    

End Sub

Private Sub cmdCreate_Click()

On Error GoTo dataerror

Dim sPath As String


sPath = txtPath.Text
If Dir(sPath, vbDirectory) = "" Then
    MkDir sPath
End If
sPath = sPath & Format(Now - TimeValue("12:00"), "yyyymmdd")
If Dir(sPath, vbDirectory) = "" Then
    MkDir sPath
End If
sPath = sPath & "\" & txtObject.Text & "\"
If Dir(sPath, vbDirectory) = "" Then
    MkDir sPath
End If

Camera.DisableAutoShutdown = True
If Not Camera.LinkEnabled Then
    Camera.LinkEnabled = True  ' Start link to camera
End If
Camera.SequenceBaseFilename = sPath & txtObject.Text
Camera.SequenceNextIndex = 1



 MsgBox sPath & " Path Created"
 Unload Me
 Exit Sub
dataerror:
MsgBox Err.Description

End Sub

Private Sub cmdExit_Click()
Unload Me
End Sub

Private Sub cmdQuit_Click()

    'User exits now
    Timer1.Enabled = False
    Camera.ShowWindow True
    txtMessage2.Caption = "Done"
    Unload Me
    

End Sub


Private Sub cmdSet_Click()

  Dim i As Integer, k As Integer
  
  txtMessage4.Visible = False
  Dim TheApp As MaxIm.Application
  Dim AllDocs As MaxIm.Documents

    Set TheApp = New MaxIm.Application

    Set AllDocs = TheApp.Documents

    For k = 0 To lstSelectedBin.ListCount - 1
        For i = 1 To AllDocs.Count
            If AllDocs.Item(i).DisplayName = lstSelectedBin.List(k) Then
                 If cmbType.ListIndex = 0 Then
                     AllDocs.Item(i).SetFITSKey txtKey.Text, CDbl(txtKeyValue.Text)
                 ElseIf cmbType.ListIndex = 1 Then
                     AllDocs.Item(i).SetFITSKey txtKey.Text, CLng(txtKeyValue.Text)
                 Else
                     AllDocs.Item(i).SetFITSKey txtKey.Text, txtKeyValue.Text
                 End If
                 Exit For
            End If
        Next
    Next
  txtMessage4.Visible = True
    

End Sub

Private Sub cmdStart_Click()

On Error GoTo dataerror

    'Set up the link to the CCD camera
    lstLog.Clear
    Camera.DisableAutoShutdown = True
    Camera.LinkEnabled = True  ' Start link to camera
    If Not Camera.LinkEnabled Then
        txtMessage2.Caption = "Failed to start camera."
        Exit Sub
    End If
    Camera.ShowWindow False
    lstLog.AddItem "CCD Connected"
    lstLog.ListIndex = lstLog.ListCount - 1
    
    'This keeps the link connected when the plug-in is closed
    Camera.DisableAutoShutdown = True

    'Turn cooler on
    Camera.CoolerOn = True
    lstLog.AddItem "Cooler Turned On"
    lstLog.ListIndex = lstLog.ListCount - 1

    'Set the CCD to -50 and start timer
    If Camera.CanSetTemperature Then
        'Set the temperature to -50
        Camera.TemperatureSetpoint = -50
        lblSetTemp.Caption = "-50"
        lstLog.AddItem "Temperature set to -50"
        lstLog.ListIndex = lstLog.ListCount - 1
    
        'setup parameters for dialog and start timer
        iTimer = 600
        iLastTemp = 100#
        lblTime.Caption = "600"
        bSetNewTemp = True

        Timer1.Enabled = True
        cmdStart.Enabled = False
    Else
        txtMessage2.Caption = "This CCD does not allow the temperature to be set."
        Camera.ShowWindow True
    End If
    Exit Sub
    
dataerror:
    Timer1.Enabled = False
    txtMessage2.Caption = Err.Description
    Camera.ShowWindow True
End Sub



Private Sub lstImagesBin_DblClick()
    lstSelectedBin.AddItem lstImagesBin.Text
    lstImagesBin.RemoveItem lstImagesBin.ListIndex

End Sub

Private Sub lstSelectedBin_DblClick()
    lstImagesBin.AddItem lstSelectedBin.Text
    lstSelectedBin.RemoveItem lstSelectedBin.ListIndex

End Sub

Private Sub optOptions_Click(Index As Integer)

'optOptions(0).Value = False
'optOptions(1).Value = False
'optOptions(Index).Value = True

Select Case Index
    Case 0
        vQuickStart.Visible = False
        vQuickPath.Visible = True
        
    Case 1
        vQuickPath.Visible = False
        vQuickStart.Visible = True
       
    Case 2
        vQuickPath.Visible = False
        vQuickStart.Visible = False
        vBin.Visible = True
        LoadBinImages
        cmbType.ListIndex = 0
        txtKey.Text = ""
        txtKeyValue.Text = ""
        txtMessage4.Visible = False
End Select



End Sub

Private Sub Timer1_Timer()


    Dim iNewTemp As Integer, j
    Dim szTemp
    
On Error GoTo dataerror

    'dec the clock
    iTimer = iTimer - 1
    
    'check previous temperature with current one.  If
    'last temperature is warmer, then set the new temperature
    
    'The 10 minute timer is done.  Set the tempature
    '3 degrees higher
    If iTimer <= 0 And bSetNewTemp Then
        If chkNoSet.Value = 1 Then
            Timer1.Enabled = False
            Camera.ShowWindow True
            txtMessage2.Caption = "Done"
            Unload Me
            Exit Sub
        Else
           szTemp = Format(Camera.Temperature, "#0.0")
           j = InStr(szTemp, ".")
           szTemp = Mid(szTemp, 1, j - 1)
           iNewTemp = CInt(szTemp)
           Camera.TemperatureSetpoint = iNewTemp * 0.89

           lblSetTemp.Caption = CStr(Camera.TemperatureSetpoint)
           bSetNewTemp = False
           lstLog.AddItem "Temperature set to " & lblSetTemp.Caption
        
           lstLog.ListIndex = lstLog.ListCount - 1
           iTimer = 120
        End If
    End If

    'Tempature should be stable now
    If iTimer <= 0 Then
        Timer1.Enabled = False
        Camera.ShowWindow True
        Unload Me
        txtMessage2.Caption = "Done"
        Exit Sub
    End If

    'Update temperature display
    lblTime.Caption = CStr(iTimer)
    lblTemp.Caption = Format(Camera.Temperature, "#0.0")
    DoEvents
    Exit Sub
    
dataerror:
    Timer1.Enabled = False
    txtMessage2.Caption = Err.Description
    Camera.ShowWindow True

End Sub

Sub LoadBinImages()

  Dim i As Integer
  Dim TheApp As MaxIm.Application
  Dim AllDocs As MaxIm.Documents

    Set TheApp = New MaxIm.Application

    Set AllDocs = TheApp.Documents

    For i = 1 To AllDocs.Count

        lstImagesBin.AddItem AllDocs.Item(i).DisplayName

    Next i





End Sub

